

********************************************************************************************************************************************************************
********************************************************************************************************************************************************************
*** Replication do-file for "The Power of Religion"
*** by Jeanet Sinding Bentzen and Gunes Gokmen
*** June, 2022
********************************************************************************************************************************************************************
********************************************************************************************************************************************************************


**********************************************************************************
**********************************************************************************
*** Table A.10: Religious laws and beliefs in high gods, disturbance to persistence
**********************************************************************************
use country_final, clear

gen persist=.
gen persist_god=.

*** Disturbance to persistence together with the p-values of the composite effect of high gods, evaluated at the 90th percentile in the distribution of the particular disturbance measure.
foreach var in settle_col2 eurfrac_other colo_dur3_d{

replace persist=`var'
replace persist_god=god*`var'

reghdfe rslegis god persist persist_god if con_3!=1, a(cont) vce(r)
*to calculate pvalues at the 90th pct
_pctile persist if e(sample), percentiles(90)
test god+persist_god*`r(r1)'=0
}


*** Disturbance to persistence together with the p-values of the composite effect of high gods, evaluated at the 80th percentile in the distribution of the particular disturbance measure.
foreach var in settle_col2 eurfrac_other colo_dur3_d{

replace persist=`var'
replace persist_god=god*`var'

reghdfe rslegis god persist persist_god if con_3!=1, a(cont) vce(r)
*to calculate pvalues at the 80th pct
_pctile persist if e(sample), percentiles(80)
test god+persist_god*`r(r1)'=0
}


********************************************************************************************************************************************************************